/*
 * Decompiled with CFR 0.152.
 */
package net.quumi.mwforestry.etc;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.quumi.mwforestry.etc.StackUtil;

public class LootGeneration {
    public static List<ItemStack> produceStacks(IBee bee, World world, float productionModifier, int productionMultiplier) {
        Float chance;
        ItemStack stack;
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        IBeeGenome genome = bee.getGenome();
        IAlleleBeeSpecies primary = genome.getPrimary();
        IAlleleBeeSpecies secondary = genome.getSecondary();
        float speed = genome.getSpeed() * productionModifier;
        for (Map.Entry stackAndChance : primary.getProductChances().entrySet()) {
            stack = (ItemStack)stackAndChance.getKey();
            chance = (Float)stackAndChance.getValue();
            if (!(world.field_73012_v.nextFloat() < chance.floatValue() * speed)) continue;
            products.add(stack);
        }
        for (Map.Entry stackAndChance : secondary.getProductChances().entrySet()) {
            stack = (ItemStack)stackAndChance.getKey();
            chance = (Float)stackAndChance.getValue();
            if (!(world.field_73012_v.nextFloat() < chance.floatValue() / 2.0f * speed)) continue;
            products.add(stack);
        }
        for (Map.Entry stackAndChance : primary.getSpecialtyChances().entrySet()) {
            stack = (ItemStack)stackAndChance.getKey();
            chance = (Float)stackAndChance.getValue();
            if (!(world.field_73012_v.nextFloat() < chance.floatValue() * speed)) continue;
            products.add(stack);
        }
        return products.stream().map(it -> StackUtil.multiplySafely(it, productionMultiplier)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

